/*
  localVariableTest.c
  John Sterling

  Have to use -pedantic to get an error for "mixing" variable
  definitions and code.  But even that does not apply to the
  definitions inside the blocks.  Are they legal???

  Even without pedantic, c89 rejects the int in the for-loop
  initialization.

  Note that b, c and i occupy the same address.

 */
#include <stdio.h>

int main() {

  printf("Hello world\n");

  int a = 17;
  printf ( "&a = %x\n", (unsigned)&a );

  {
    int b = 42;
    printf ( "&b = %x\n", (unsigned)&b );
  }

  {
    double c = 3.14;
    printf ( "&c = %x\n", (unsigned)&c );
  }

  for (int i = 0; i < 5; ++i)
    printf("i = %d; &i = %x\n", i, (unsigned)&i);

  return 0;
}
